# Güvenli sunucu konfigürasyonu
import os
from dotenv import load_dotenv

# .env dosyasını yükle
load_dotenv()

# Sunucu bilgileri - güvenli şekilde environment variable'dan alınır
SERVER_HOST = os.getenv('SERVER_HOST', 'localhost')  # Varsayılan localhost
SERVER_PORT = int(os.getenv('SERVER_PORT', '8765'))  # Varsayılan port 8765

# Güvenlik: Eğer environment variable yoksa uyarı ver
if SERVER_HOST == 'localhost':
    print("⚠️  UYARI: SERVER_HOST environment variable bulunamadı. Localhost kullanılıyor.")
    print("   Ubuntu sunucunuza bağlanmak için .env dosyası oluşturun.")
